package gov.va.vinci.dart.json.builder;

import java.util.List;

import gov.va.vinci.dart.biz.Request;
import gov.va.vinci.dart.biz.RequestWorkflow;
import gov.va.vinci.dart.biz.Review;
import gov.va.vinci.dart.json.ReviewStatusListView;

public class ReviewStatusListViewBuilder {

	ReviewStatusViewBuilder statusViewBuilder = new ReviewStatusViewBuilder();

	public ReviewStatusListView build(final RequestWorkflow workflow, final Request request, final List<Review> reviewList) {
		ReviewStatusListView result = new ReviewStatusListView();
		
		result.setTrackingNumber(request.getTrackingNumber());

		for (Review review : reviewList) {
			result.getReviews().add(statusViewBuilder.populateReviewStatus(workflow, request, review));
		}

		return result;
	}
}
